<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contact;
use Validator;

class SubscribeController extends Controller
{
    public function index()
    {
        $data = Contact::latest()->get();
        return view('module.contact.index', compact('data'));
    }

    public function store(Request $request)
    {
        // return $request;
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255','unique:contacts,email'],
            'phone' => ['required', 'string', 'max:255'],
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        Contact::create([
            'phone' => $request->phone,
            'name' => $request->name,
            'email' => $request->email,
        ]);

        return back()->with('success', 'Thank you for subscribing us. We will update you through your email.');
    }

    public function destroy($id)
    {
        Contact::findOrFail($id)->delete();

        return back()->with('success', 'Successfully deleted subscriber');
    }
}
