<?php

namespace App\Http\Controllers\Admin\Page\TextImagesManagement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Page\TextImagesManagement\HistoryContent;
use Validator;
use Str;

class HistoryContentController extends Controller
{
    
    public function index()
    {
        $data = HistoryContent::latest()->get();
        return view('module.text-images-management.history-content.index', compact('data'));
    }

    
    public function create()
    {
        //
    }

   
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'date' => 'required',
            'title' => 'required',
            'file' => 'required|image|mimes:jpeg,png,jpg|max:1048',
            'content' => 'required'
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        if($request->file){
            $path = public_path().'/uploads/history-content';
            $img = date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->file->getClientOriginalExtension();
            $request->file->move($path,$img);
            $request->file = $img;

        }

        HistoryContent::create([
            'date' => $request->date,
            'title' => $request->title,
            'file' => $request->file,
            'content' => $request->content,
        ]);

        return back()->with('success', 'Successfully added new history content');
    }

    
    public function show($id)
    {
        //
    }

    
    public function edit($id)
    {
        //
    }

    
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'date' => 'required',
            'title' => 'required',
            'file' => 'image|mimes:jpeg,png,jpg|max:1048',
            'content' => 'required'
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        $historyContent = HistoryContent::findOrFail($id);
        $historyContent->date = $request->date;
        $historyContent->title = $request->title;
        $historyContent->content = $request->content;

        if($request->file){
            $path = public_path().'/uploads/history-content';
            $file_name = date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->file->getClientOriginalExtension();
            $request->file->move($path,$file_name);
            $historyContent->file = $file_name;
        }

        $data = HistoryContent::findOrFail($id);
        $historyContent->save();

        if($request->file and $data->file){
            $path = public_path().'/uploads/history-content/';
            unlink($path.$data->file);
        }

        return back()->with('success', 'Successfully updated history content');

    }

    
    public function destroy($id)
    {
        $data = HistoryContent::findOrFail($id);
        $data->delete();

        if($data->file){
            $path = public_path().'/uploads/history-content/';
            unlink($path.$data->file);
        }

        return back()->with('success', 'Successfully deleted history content');
    }
}
