<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Validator;
use Auth;
use Str;
use Session;

class PageController extends Controller
{
    
    public function dashboard(){
    	return view('module.dashboard');
    }

    public function profile(){
    	return view('module.profile.index');
    }

    public function activation($id, Request $request){
    	$user = User::findOrFail($id);
    	$user->activation = $request->activation;
    	$user->save();
	    return back()->withInput()->with('success','Successfully updated activation of user');
    }

    public function update_password(Request $request, $id){
        $hashedPassword = Auth::user()->password;
        // Session::put('account-setting', 'password');
        // return $hashedPassword;
        if (\Hash::check($request->oldpassword , $hashedPassword )) {

            if (!\Hash::check($request->password , $hashedPassword)) {
                $validator = Validator::make($request->all(), [
                    'password' => ['required', 'string', 'min:8','confirmed'],
                ]);
                if ($validator->fails()) {
                    return back()->withInput()->with('error','comfirm password not match')->withErrors($validator);
                    // return redirect()->back()->withInput()->withErrors($validator);
                }
                $users = User::findOrFail(Auth::user()->id);
                $users->password = $request->password;
                $users->save();

                return back()->withInput()->with('success','password updated successfully');
            }

            else{
                return back()->withInput()->with('error','new password can not be the same as the old password!');
            }
        }
        else{
            return back()->withInput()->with('error', 'old password doesnt matched ');
        }
    }

    public function reset(Request $request, $id){
        $user = User::findOrFail($id);
        // return $user;
        $user->password = 'quanta.2022';
        $user->save();

        return back()->with('success', 'Successfully reset user password');
    }

    public function update_profile(Request $request, $id){
        $user = User::findOrFail($id);
        // return $user;
        $destinationPath = public_path().'/uploads/profile';
        $img = 'profile_'.date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
        $request->image->move($destinationPath,$img);
        $user->image = $img;

        // $pathToImage = public_path().'/uploads/profile/'.$img;
        // ImageOptimizer::optimize($pathToImage);

        $data = User::findOrFail($id);
        $user->save();

        if($request->image and $data->image){
            $destinationPath = public_path().'/uploads/profile/';
            unlink($destinationPath.$data->image);
        }

        return back()->with('success', 'Successfully updated profile');
    }
}
