<?php

namespace App\Http\Controllers\Front;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{

    public function login()
    {
        if (Auth::check()) {
            if (Auth::user()->role === 'Customer') {
                return redirect('/user/dashboard');
            }
            if (Auth::user()->role === 'Admin') {
                return redirect('/admin/dashboard');
            }
        }

        return view('layouts.front.auth.login');
    }

    public function signin(Request $request)
    {
        $request->validate([
            'email' => 'required|email|exists:users,email',
            'password' => 'required'
        ]);


        $credentials = $request->only('email', 'password');
        // dd($credentials);
        // dd(Auth::attempt($credentials));
        if (Auth::attempt($credentials)) {
            // dd(Auth::user()->role);
            if (Auth::user()->role === 'Customer') {
                return redirect('user/dashboard')->with('success', 'Successfully Signin.');
            }
            Auth::logout();
            return redirect('/user/login')->withErrors(['email' => 'Invalid account.']);
        }

            return back()->withInput()->with('error', 'Invalid!');

    }

    public function register()
    {
        if (Auth::check()) {
            if (Auth::user()->role === 'Customer') {
                return redirect('/user/dashboard');
            }
            if (Auth::user()->role === 'Admin') {
                return redirect('/admin/dashboard');
            }
        }

        return view('layouts.front.auth.register');
    }

    public function signup(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required'
        ]);
        // return $request;

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => $request->password,
            // 'password' => Hash::make($request->password),
            'role' => 'Customer'
        ]);

        return redirect('user/login')->with('success', 'Successfully Registered');

    }

    public function updateProfile(Request $request)
    {
        $request->validate([
            'email' => 'required|email|unique:users,email,' . auth()->user()->id,
        ]);

        auth()->user()->update([
            'email' => $request->email,
            'name,' => $request->name,
        ]);

        return redirect('/user/dashboard')->with('success', 'Profile Updated Successfully!');
    }

    public function changePassword(Request $request)
    {
        $request->validate([
            'password' => 'required'
        ]);

        auth()->user()->update([
            'password' => Hash::make($request->password)
        ]);

        return redirect('/user/dashboard')->with('success', 'Password Updated Successfully!');
    }

    public function logout(Request $request)
    {
        Auth::logout();
        return redirect('/user/login')->with('success', 'Successfully Signout.');
    }
}
