<?php

namespace App\Mail;

use App\Models\Order;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class OrderMail extends Mailable
{
    use Queueable, SerializesModels;

    public $result;
    public $payment_method;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($result, $payment_method)
    {
        $this->result = $result;
        $this->payment_method = $payment_method;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if ($this->payment_method == 'paypal') {
            return $this->subject('Order Paypal')->view('mails.order-mail');
        }
        return $this->subject('Order Stripe')->view('mails.order-mail');
    }
}
