@extends('layouts.front.app-no-hf')
@section('meta')
	<title>Login | {{ env('APP_NAME') }}</title>
@stop

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('css/authentication.min.css') }}">
    
    <style>
        html body.bg-full-screen-image{
            background: linear-gradient(0deg, rgb(242 221 207) 14%, rgb(242 221 207) 100%);
        }
        .btn-primary{
            background-color: #996666 !important;
        }
        .form-control:focus {
            color: #996666 !important;
            border-color: #996666 !important;
        }
        .form-control:focus~.form-control-position i {
            color: #996666 !important;
        }
        .form-label-group>input:focus:not(:placeholder-shown)~label, .form-label-group>input:not(:active):not(:placeholder-shown)~label {
            color: #996666 !important;
        }
        .vs-checkbox-primary input:active:checked+.vs-checkbox .vs-checkbox--check {
            background-color: #996666 !important;
        }
        .vs-checkbox-primary input:checked~.vs-checkbox {
            border-color: #996666!important;
        }
        .vs-checkbox-primary input:checked~.vs-checkbox .vs-checkbox--check {
            background-color: #996666!important;
        }
        a{
            color: #996666 !important;
        }
    </style>
@endsection

@section('content')
    
<body class="vertical-layout vertical-menu-modern 1-column  navbar-floating footer-static bg-full-screen-image  blank-page blank-page" data-open="click" data-menu="vertical-menu-modern" data-col="1-column">
    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body">
                <section class="row flexbox-container">
                    <div class="col-xl-8 col-11 d-flex justify-content-center">
                        <div class="card bg-authentication rounded-0 mb-0 position-relative">
                            <div class="position-absolute ps-3 pt-1 zindex-1">
                                 <a href="{{url('/')}}"><i class="fa fa-arrow-left "></i>Home</a> 
                            </div>
                            <div class="row m-0">
                                <div class="col-lg-6 d-lg-block d-none text-center align-self-center px-1 py-0">
                                    <img class="pt-4" src="{{ asset('images/authentication/login.jpg') }}" alt="branding logo">
                                </div>
                                <div class="col-lg-6 col-12 p-0">
                                    <div class="card rounded-0 mb-0 px-2">
                                        <div class="card-header pb-1">
                                            <div class="card-title">
                                                <h4 class="mb-0">Login</h4>
                                            </div>
                                        </div>
                                        <p class="px-2">Welcome back, please login to your account.</p>
                                        <div class="card-content mb-2">
                                            <div class="card-body pt-1">
                                                <form action="{{ url('/user/login') }}" method="post">@csrf
                                                    <fieldset class="form-label-group form-group position-relative has-icon-left">
                                                        <input name="email" type="email" class="form-control @error('email') is-invalid @enderror" id="email" placeholder="Email" value="{{ old('email') }}" required>
                                                        <div class="form-control-position">
                                                            <i class="fa fa-user"></i>
                                                        </div>
                                                        @error('email')
                                                            <span class="invalid-feedback" role="alert">
                                                                <strong>{{ $message }}</strong>
                                                            </span>
                                                        @enderror
                                                        <label for="user-name">Email Address</label>
                                                    </fieldset>

                                                    <fieldset class="form-label-group position-relative has-icon-left">
                                                        <input type="password" name="password" class="form-control" id="user-password" placeholder="Password" required>
                                                        <div class="form-control-position">
                                                            <i class="fa fa-lock"></i>
                                                        </div>
                                                        <label for="user-password">Password</label>
                                                    </fieldset>


                                                        {{-- <div class="form-group d-flex justify-content-between align-items-center">
                                                            <div class="text-left">
                                                                <fieldset class="checkbox">
                                                                    <div class="vs-checkbox-con vs-checkbox-primary">
                                                                        <input type="checkbox">
                                                                        <span class="vs-checkbox">
                                                                            <span class="vs-checkbox--check">
                                                                                <i class="vs-icon feather icon-check"></i>
                                                                            </span>
                                                                        </span>
                                                                        <span class="">Remember me</span>
                                                                    </div>
                                                                </fieldset>
                                                            </div>
                                                            <div class="text-right">
                                                                <a href="{{ url('password.request') }}" class="card-link">Forgot Password?</a>
                                                            </div>
                                                        </div> --}}
                                                        <div class="form-group d-flex justify-content-between align-items-center">
                                                            <div class="text-start">
                                                                Don't have an account?<a href="{{ url('/user/register') }}" class="card-link"> register</a>
                                                            </div>
                                                        </div>
                                                    {{-- <a href="" class="btn btn-outline-primary float-left btn-inline">Register</a> --}}
                                                    <button type="submit" class="btn btn-primary float-left btn-inline">Login</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
        </div>
    </div>
</body>
@endsection

@section('js')
<script src="{{ asset('js/authentication.min.js') }}"></script>
@endsection
