<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Order Confirmation</title>
    <style>
    td, th {
    border: 1px solid;
    padding: 2.5px 7.5px;
    }
    .text-white {
        color: white;
    }
    .bg-website {
        background-color: #2e3181;
    }
    .text-center {
        text-align: center;
    }
    .text-end {
        text-align: right;
    }
    .text-start {
        text-align: left;
    }
    .border{
        border: 5px solid #2e3181;
    }
    .rounded-pill{
        border-radius: 50px;
    }
    .p-3{
        padding: 1rem;
    }
    .d-flex{
        display: flex;
    }
    .fs-2{
        font-size: 2rem;
    }

    .mb-3{
        margin-bottom: 2rem;
    }
    .w-100{
        width: 100%;
    }
    .w-50{
        width: 50%;
    }
    </style>
</head>
<body>

    <?php
        $info = $result->payer->payer_info;
        $address = $result->payer->payer_info->shipping_address;
        $transactions = $result->transactions[0];

        $bill_name = $info->first_name.' '.$info->last_name;
        $bill_email = $info->email;
        $bill_address = $address->line1.' '.$address->city.' '.$address->state.' '.$address->postal_code.' '.$address->country_code;

        $total_amount = $transactions->amount->total;
        $items = $transactions->item_list->items;
    ?>

    <img src="<?php echo e(asset('images/logo.png')); ?>" alt="">

    <br>
    <br>
    Invoice Information:
    <br>
    Invoice Name: <?php echo e($bill_name); ?>

    <br>
    Invoice Email: <?php echo e($bill_email); ?>

    <br>
    Invoice Address: <?php echo e($bill_address); ?>

    <br>
    Payment Method: <?php echo e($payment_method); ?>

    <br>
    
    <br>
    <br>

    <table style="width: 100%; text-align: left;border-collapse: collapse;">
        <thead>
            <tr>
                <th class="text-center">PRODUCT NAME</th>
                <th class="text-center">PRICE</th>
                <th class="text-center">QTY</th>
                <th class="text-center">PAYMENT METHOD</th>
                <th class="text-center">SUB TOTAL</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($item->name); ?></td>
                    <td class="text-center">$<?php echo e($item->price); ?></td>
                    <td class="text-center"><?php echo e($item->quantity); ?></td>
                    <td class="text-center"><?php echo e($payment_method); ?></td>
                    <td class="text-center">$<?php echo e(number_format(intval($item->quantity) * floatval($item->price),2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="6">
                        <h2 style="text-align: right;">
                            ORDER TOTAL: <span class="text-website fw-1000"><?php echo e($total_amount); ?></span>
                        </h2>
                    </td>
                </tr>
        </tbody>
    </table>

</body>
</html>
<?php /**PATH C:\Users\PC4\Desktop\thedreway\resources\views/mails/order-mail.blade.php ENDPATH**/ ?>