<?php

namespace App\Exports;

use App\Models\Applicants;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class ApplicantsExport implements FromCollection, WithHeadings, ShouldAutoSize
{
    public function collection()
    {
        return Applicants::with('career')->get()->map(function ($applicant) {
            return [
                'Job Title'       => $applicant->career->title,
                'Name'            => $applicant->name,
                'Contact Number'  => $applicant->contact_number,
                'Email'           => $applicant->email,
                'Address'         => $applicant->address,
                'Resume'          => asset($applicant->resume),
            ];
        });
    }

    public function headings(): array
    {
        return ['Job Title', 'Name', 'Contact Number', 'Email', 'Address', 'Resume'];
    }
}
