<?php

namespace App\Http\Controllers\Admin\Page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Corrugated;
use Validator;
use Str;

class CorrugatedController extends Controller
{
    
    public function index()
    {
        $data = Corrugated::latest()->get();
        return view('module.corrugated.index', compact('data'));
    }

    
    public function create()
    {
        //
    }

    
    public function store(Request $request)
    {
        // 'name', 'email', 'phone_num', 'color', 'height', 'width', 'depth', 'unit', 'deliver_date', 'quality', 'paper_type', 'docu', 'note'
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required',
            'phone_num' => 'required',
            // 'color' => 'required',
            // 'height' => 'required',
            // 'width' => 'required',
            // 'depth' => 'required',
            // 'unit' => 'required',
            'deliver_date' => 'required',
            'quantity' => 'required',
            'paper_type' => 'required',
            'docu' => 'max:1048',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        if($request->docu){
            $file = $request->file('docu');
            // return $request->docu;
            $path = public_path().'/uploads/corrugated';
            $img = str_replace(' ', '_', $request->name).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$file->getClientOriginalExtension();
            $request->docu->move($path,$img);
            $request->docu = $img;

        }

        Corrugated::create([
            'name' => $request->name,
            'email' => $request->email,
            'phone_num' => $request->phone_num,
            'color' => $request->color,
            // 'height' => $request->height,
            // 'width' => $request->width,
            // 'depth' => $request->depth,
            // 'unit' => $request->unit,
            'total' => $request->total,
            'deliver_date' => $request->deliver_date,
            'quantity' => $request->quantity,
            'paper_type' => $request->paper_type,
            'note' => $request->note,
            'docu' => $request->docu,
        ]);

        return back()->with('message', 'Successfully send request quotation');
    }

    
    public function show($id)
    {
        //
    }

    
    public function edit($id)
    {
        //
    }

    
    public function update(Request $request, $id)
    {
        //
    }

    
    public function destroy($id)
    {
        //
    }
}
