<?php

namespace App\Http\Controllers\Admin\Page\News;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\News\News;
use Validator;
use Str;

class NewsController extends Controller
{
    
    public function index()
    {
        $data = News::latest()->get();
        return view('module.news.news.index', compact('data'));
    }

    
    public function create()
    {
        return view('module.news.news.create');
    }

    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'tag_id' => 'required',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:1048',
            'description' => 'required',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        if($request->image){
            $path = public_path().'/uploads/news';
            $img = str_replace(' ', '_', $request->title).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $request->image = $img;

        }

        News::create([
            'title' => $request->title,
            'tag_id' => json_encode($request->tag_id),
            'image' => $request->image,
            'description' => $request->description,
        ]);

        return redirect('Admin/News')->with('success', 'Successfully added new news');
    }

    
    public function show($id)
    {
        //
    }

    
    public function edit($id)
    {
        $data = News::findOrFail($id);
        return view('module.news.news.update', compact('data'));
    }

    
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'tag_id' => 'required',
            'image' => 'image|mimes:jpeg,png,jpg|max:1048',
            'description' => 'required',
        ]);

        if($validator->fails()){
            return back()->withInput()->withErrors($validator);
        }

        $news = News::findOrFail($id);
        $news->title = $request->title;
        $news->tag_id = json_encode($request->tag_id);
        $news->description = $request->description;

        if($request->image){
            $path = public_path().'/uploads/news';
            $img = str_replace(' ', '_', $request->title).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->image->getClientOriginalExtension();
            $request->image->move($path,$img);
            $news->image = $img;
        }

        $data = News::findOrFail($id);
        $news->save();

        if($request->image and $data->image){
            $path = public_path().'/uploads/news/';
            unlink($path.$data->image);
        }
        return redirect('Admin/News')->with('success', 'Successfully updated news');
    }

    
    public function destroy($id)
    {
        $data = News::findOrFail($id);
        $data->delete();

        if($data->image){
            $path = public_path().'/uploads/news/';
            unlink($path.$data->image);
        }
        return redirect('Admin/News')->with('success', 'Successfully deleted news');
    }
}
