<?php

namespace App\Http\Controllers\Admin\Page\TextImagesManagement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Page\TextImagesManagement\OurProductsContent;
use Validator;
use Str;

class OurProductsContentController extends Controller
{
    
    public function index()
    {
        return view('module.text-images-management.our-products-content.index');
    }

    // public function store(Request $request)
    // {
    //     $validator = Validator::make($request->all(), [
    //         'title' => 'required',
    //         'tag_id' => 'required',
    //         'file' => 'required|file|mimes:jpeg,png,jpg|max:1048',
    //         'description' => 'required',
    //     ]);

    //     if($validator->fails()){
    //         return back()->withInput()->withErrors($validator);
    //     }

    //     if($request->file){
    //         $path = public_path().'/uploads/homeContent';
    //         $file = str_replace(' ', '_', $request->title).date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->file->getClientOriginalExtension();
    //         $request->file->move($path,$file);
    //         $request->file = $file;

    //     }

    //     OurProductsContent::create([
    //         'title' => $request->title,
    //         'tag_id' => json_encode($request->tag_id),
    //         'file' => $request->file,
    //         'description' => $request->description,
    //     ]);

    //     return redirect('Admin/homeContent')->with('success', 'Successfully added new homeContent');
    // }

    
    // public function show($id)
    // {
    //     return $id;
        
    // }

    
    // public function edit($id)
    // {
    //     return $id;

    //     $data = OurProductsContent::findOrFail($id);
    //     return view('module.text-images-management.our-products-content.update', compact('data'));
    // }

    
    public function update(Request $request, $id)
    {
        // return $request;

        $request->validate([
            'file' => 'max:21000',
        ]);

        $homeContent = OurProductsContent::findOrFail($id);
        $homeContent->file = $request->file;
        $homeContent->title = $request->title;
        $homeContent->subtitle = $request->subtitle;
        $homeContent->content = $request->content;

        if($request->file){
            back()->with('uploading', 'Uploading');
            $path = public_path().'/uploads/our-products-content';
            $file_name = date_format(date_create(), 'mdyHis').Str::random(5).'.'.$request->file->getClientOriginalExtension();
            $request->file->move($path,$file_name);
            $homeContent->file = $file_name;
        }

        $data = OurProductsContent::findOrFail($id);
        $homeContent->save();

        if($request->file and $data->file){
            $path = public_path().'/uploads/our-products-content/';
            unlink($path.$data->file);
        }
        return back()->with('success', 'Successfully updated our products content');
    }

    
    // public function destroy($id)
    // {
    //     $data = OurProductsContent::findOrFail($id);
    //     $data->delete();

    //     if($data->file){
    //         $path = public_path().'/uploads/home-content/';
    //         unlink($path.$data->file);
    //     }
    //     return back()->with('success', 'Successfully deleted home content');
    // }
}
