<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Searchable\SearchResult;
use Spatie\Searchable\Searchable;

class Blog extends Model implements Searchable
{
    use HasFactory;

    protected $fillable = [
    	'tag_id', 'title', 'client', 'image', 'blog_date', 'description'
    ];

    public function getSearchResult(): SearchResult
     {
        $url = url('blog/'.str_replace([' ','/'], ['_','`'], $this->title));
     
         return new \Spatie\Searchable\SearchResult(
            $this,
            $this->title,
            $url
         );
     }
}
