<?php

namespace App\Models\News;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Spatie\Searchable\Searchable;
use Spatie\Searchable\SearchResult;

class News extends Model implements Searchable
{
    use HasFactory;

    protected $fillable = [
    	'tag_id', 'title', 'image', 'description'
    ];

    public function getSearchResult(): SearchResult
     {
        $url = url('news/'.str_replace([' ','/'], ['_','`'], $this->title));
     
         return new \Spatie\Searchable\SearchResult(
            $this,
            $this->title,
            $url
         );
     }
}
