@extends('layouts.admin.app')
@section('content')
    <div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">List View</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('home') }}">Home</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="{{ url('Admin/Blogs') }}">Blogs</a>
                                    </li>
                                    <li class="breadcrumb-item active">
                                        Create
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('include.alert')
            
            <div class="content-body bg-white p-3">
                <form method="post" class="row" action="{{ url('Admin/Blogs') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group col-xl-12">
                        <small> Image Should be less than 1mb *</small>
                        <div class="input-group">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="image" id="file" accept=".png,.jpeg,.jpg" required="">
                                <label class="custom-file-label light_gray" for="exampleInputFile">UPLOAD ONE(1) IMAGE WITH DIMENSIONS (1200x700)</label>
                            </div>
                        </div>
                        <div id="alert-col">
                        </div>
                        <div class="gallery" id="gallery2">
                            
                        </div>
                    </div>
                    
                    <div class="form-group col-lg-12">
                        <small>Title*</small>
                        <input type="text" name="title" class="form-control" value="{{ old('title') }}" placeholder="Title" required="">
                    </div>

                    <div class="form-group col-lg-12">
                        <small>Tags*</small>
                        <select class="form-control select2" name="tag_id[]" multiple="" required="">
                            <option></option>
                            @foreach(App\Models\Tag::latest()->get() as $tag)
                            <option value="{{ $tag->id }}">{{ $tag->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-lg-6">
                        <small>Client*</small>
                        <input type="text" name="client" class="form-control" value="{{ old('client') }}" placeholder="Client" required="">
                    </div>

                    <div class="form-group col-lg-6">
                        <small>Blog Date*</small>
                        <input type="date" name="blog_date" class="form-control" value="{{ old('blog_date') }}" placeholder="Blog Date" required="">
                    </div>

                    <div class="form-group col-xl-12">
                        <small>Description</small>
                        <textarea name="description" id="description" class="form-control" rows="5" required="">{{ old('description') }}</textarea>
                    </div>
                    
                    <div class="form-group text-center col-xl-12">
                        <button class="btn btn-primary" type="submit" id="submit">ADD</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('js/filereader.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/4.16.0/standard/ckeditor.js"></script>
    <script type="text/javascript">
        CKEDITOR.replace('description');
        var uploadField = document.getElementById("file");

        uploadField.onchange = function() {
          const fsize = this.files[0].size;
          const file = Math.round((fsize / 1048)); 
          if (file >= 1048) { 
            $('#file').addClass('is-invalid');
            document.getElementById('alert-col').innerHTML = '<small class="text-danger">File too Big, please select a file less than 1mb </small>';
            $('#submit').prop('disabled', true);
          }else{
            $('#file').removeClass('is-invalid');
            document.getElementById('alert-col').innerHTML = '';
            $('#submit').prop('disabled', false);
          }
        };

        var imagesPreview = function(input, placeToInsertImagePreview) {

            if (input.files) {
                var filesAmount = input.files.length;

                for (i = 0; i < filesAmount; i++) {
                    var reader = new FileReader();

                    reader.onload = function(event) {
                        $($.parseHTML('<img class="img-fluid">')).attr('src', event.target.result).appendTo(placeToInsertImagePreview);
                    }

                    reader.readAsDataURL(input.files[i]);
                }
            }

        };

        $('#file').on('change', function() {
            $('#gallery2 img').remove();
            imagesPreview(this, 'div#gallery2');
        });

        
    </script>
@stop