@extends('layouts.admin.app')
@section('meta')
    <link rel="stylesheet" type="text/css" href="{{ asset('css/email.min.css') }}">
@stop
@section('content')
	<div class="modal fade text-left" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel120" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger white">
                    <h5 class="modal-title" id="myModalLabel120">Delete Data</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this data?
                </div>
                <div class="modal-footer">
                    <form method="post" action="{{ url('delete/1') }}" class="btn-ok"> @csrf @method('delete')
                    	<button type="submit" class="btn btn-danger">
                    	  	Yes
                    	</button>
                  	</form>
					<button type="button" class="btn btn-primary" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
	<div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">List View</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                    	<a href="{{ url('home') }}">Home</a>
                                    </li>
                                    {{-- <li class="breadcrumb-item">
                                    	<a href="#">Data List</a>
                                    </li> --}}
                                    <li class="breadcrumb-item active">
                                    	Comments
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('include.alert')
            
            <div class="content-body">
                <!-- Data list view starts -->
                <div class="email-application">
                    <div class="content-area-wrapper mt-0">
                        <div class="sidebar-left">
                            <div class="sidebar">
                                <div class="sidebar-content email-app-sidebar">
                                    <div class="email-app-menu">
                                        {{-- <div class="form-group-compose text-center compose-btn">
                                            <button type="button" class="compose-email btn btn-primary btn-block" data-backdrop="false" data-toggle="modal" data-target="#compose-mail">
                                                Compose
                                            </button>
                                        </div> --}}
                                        <div class="sidebar-menu-list">
                                            <div class="list-group list-group-messages">
                                                <a href="javascript:void(0)" class="list-group-item list-group-item-action active">
                                                    <i data-feather="mail" class="font-medium-3 mr-50"></i>
                                                    <span class="align-middle">Inbox</span>
                                                    <span class="badge badge-light-primary badge-pill float-right">{{ count($data) }}</span>
                                                </a>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="content-right">
                            <div class="content-wrapper">
                                <div class="content-header row">
                                </div>
                                <div class="content-body">
                                    <div class="body-content-overlay"></div>
                                    <!-- Email list Area -->
                                    <div class="email-app-list">
                                        <!-- Email search starts -->
                                        <div class="app-fixed-search d-flex align-items-center">
                                            <div class="sidebar-toggle d-block d-lg-none ml-1">
                                                <i data-feather="menu" class="font-medium-5"></i>
                                            </div>
                                            <div class="d-flex align-content-center justify-content-between w-100">
                                                <div class="input-group input-group-merge">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text"><i data-feather="search" class="text-muted"></i></span>
                                                    </div>
                                                    <input type="text" class="form-control" id="email-search" placeholder="Search email" aria-label="Search..." aria-describedby="email-search" />
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Email search ends -->

                                        <!-- Email list starts -->
                                        <div class="email-user-list">
                                            @if(count($data) > 0)
                                            <ul class="email-media-list">
                                                @foreach($data as $value)
                                                <li class="media mail-read" data-id="{{ $value->id }}">
                                                    <div class="media-left pr-50">
                                                        <div class="avatar">
                                                            <img src="{{ asset('images/avatar.jpg') }}" alt="avatar img holder" />
                                                        </div>
                                                    </div>
                                                    <div class="media-body">
                                                        <div class="mail-details">
                                                            <div class="mail-items">
                                                                <h5 class="mb-25">
                                                                    {{ $value->name }} 
                                                                    
                                                                </h5>
                                                                <span class="text-truncate">
                                                                    @if($value->blog_id)
                                                                    {{ $value->blog->title }}
                                                                    @elseif($value->event_id)
                                                                    {{ $value->event->title }}
                                                                    @elseif($value->news_id)
                                                                    {{ $value->news->title }}
                                                                    @endif
                                                                    Comment
                                                                </span>
                                                            </div>
                                                            <div class="mail-meta-item">
                                                                <span class="mr-50 bullet bullet-success bullet-sm"></span>
                                                                <span class="mail-date">{{ $value->created_at->diffForHumans() }}</span>
                                                            </div>
                                                        </div>
                                                        <div class="mail-message">
                                                            <p class="text-truncate mb-0">
                                                                {{ $value->message }}
                                                            </p>
                                                        </div>
                                                    </div>
                                                </li>
                                                @endforeach
                                            </ul>
                                            @else
                                            <div class="no-results">
                                                <h5>No Items Found</h5>
                                            </div>
                                            @endif
                                        </div>
                                        <!-- Email list ends -->
                                    </div>
                                    <!--/ Email list Area -->
                                    <!-- Detailed Email View -->
                                    @foreach($data as $value)
                                    <div class="email-app-details" id="email{{ $value->id }}">
                                        <div class="email-detail-header">
                                            <div class="email-header-left d-flex align-items-center">
                                                <span class="go-back mr-1"><i data-feather="chevron-left" class="font-medium-4"></i></span>
                                                <h4 class="email-subject mb-0">
                                                    @if($value->blog_id)
                                                    {{ $value->blog->title }}
                                                    @elseif($value->event_id)
                                                    {{ $value->event->title }}
                                                    @elseif($value->news_id)
                                                    {{ $value->news->title }}
                                                    @endif
                                                </h4>
                                            </div>
                                            <div class="email-header-right ml-2 pl-1">
                                                <ul class="list-inline m-0">
                                                    
                                                    <li class="list-inline-item">
                                                        <a class="delte text-danger" data-href="{{ url('Admin/User-Comments/'.$value->id) }}" id="deletecart">
                                                            <span class="action-icon"><i data-feather="trash" class="font-medium-2"></i></span>
                                                        </a>
                                                    </li>
                                                    {{-- <li class="list-inline-item email-prev">
                                                        <span class="action-icon"><i data-feather="chevron-left" class="font-medium-2"></i></span>
                                                    </li>
                                                    <li class="list-inline-item email-next">
                                                        <span class="action-icon"><i data-feather="chevron-right" class="font-medium-2"></i></span>
                                                    </li> --}}
                                                </ul>
                                            </div>
                                        </div>

                                        <div class="email-scroll-area px-0">
                                            <br>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="card">
                                                        <div class="card-header email-detail-head">
                                                            <div class="user-details d-flex justify-content-between align-items-center flex-wrap">
                                                                <div class="avatar mr-75">
                                                                    <img src="{{ asset('images/avatar.jpg') }}" alt="avatar img holder" width="48" height="48" />
                                                                </div>
                                                                <div class="mail-items">
                                                                    <h5 class="mb-0">{{ $value->name }}</h5>
                                                                    <div class="email-info-dropup">
                                                                        <span role="button" class="dropdown-toggle font-small-3 text-muted" id="card_top01" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                            {{ $value->email }}
                                                                        </span>
                                                                        <div class="dropdown-menu" aria-labelledby="card_top01">
                                                                            <table class="table table-sm table-borderless">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td class="text-right">From:</td>
                                                                                        <td>{{ $value->email }}</td>
                                                                                    </tr>
                                                                                    <tr>
                                                                                        <td class="text-right">Date:</td>
                                                                                        <td>{{ date('j F, Y h:i a', strtotime($value->created_at)) }}</td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="mail-meta-item d-flex align-items-center">
                                                                <small class="mail-date-time text-muted">{{ date('j F, Y h:i a', strtotime($value->created_at)) }}</small>
                                                            </div>
                                                        </div>
                                                        <div class="card-body mail-message-wrapper pt-2">
                                                            <div class="mail-message">
                                                                <p class="card-text">
                                                                    {{ $value->message }}
                                                                </p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- @foreach($data as $value)
    @include('module.story.update')
    @endforeach --}}
@endsection
@section('js')
    <script src="{{ asset('js/email.min.js') }}"></script>
    <script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
	<script>
	</script>
	<script>
        // CKEDITOR.replace('message');
	  $(function () {
	    // $("#example1").DataTable();
	    $('#example1').DataTable({
	      "paging": true,
	      "pageLength": 50,
	      "lengthChange": true,
	      "searching": true,
	      "ordering": false,
	      "info": true,
	      "autoWidth": false,
	    });
	    $('.select2').select2();
	    $('.select2bs4').select2({
	      theme: 'bootstrap4'
	    });
	  });
	  	$('.delte').click(function () {
			var id = $(this).data('href');
			$('.btn-ok').attr('action', id);
			$('#deleteModal').modal('show');
		});

        $('.email-media-list li').click(function(event) {
            id = $(this).attr('data-id');
            $('.email-app-details').removeClass('show');
            $('#email'+id).addClass('show');
        });
	</script>
@endsection