@extends('layouts.admin.app')

@section('content')
	<div class="modal fade text-left" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel120" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header bg-danger white">
                    <h5 class="modal-title" id="myModalLabel120">Delete Data</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this data?
                </div>
                <div class="modal-footer">
                    <form method="post" action="{{ url('delete/1') }}" class="btn-ok"> @csrf @method('delete')
                    	<button type="submit" class="btn btn-danger">
                    	  	Yes
                    	</button>
                  	</form>
					<button type="button" class="btn btn-primary" data-dismiss="modal">No</button>
                </div>
            </div>
        </div>
    </div>
	<div class="app-content content" id="table-hover-animation">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs">
                        <div class="col-12">
                            <h2 class="content-header-title float-left mb-0">List View</h2>
                            <div class="breadcrumb-wrapper col-12">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                    	<a href="{{ url('home') }}">Home</a>
                                    </li>
                                    {{-- <li class="breadcrumb-item">
                                    	<a href="#">Data List</a>
                                    </li> --}}
                                    <li class="breadcrumb-item active">
                                    	Subscribers
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @include('include.alert')
            
            <div class="content-body">
                <!-- Data list view starts -->
                <section id="data-list-view" class="data-list-view-header">
                    
                    <!-- DataTable starts -->
                    <div class="table-responsive">
                        <table class="table table-striped zero-configuration {{-- dataex-html5-selectors --}} table-hover-animation">
                            <thead>
                                <tr>
                                    {{-- <th></th> --}}
                                    <th>FULLNAME</th>
                                    <th>CONTACT</th>
                                    <th>EMAIL</th>
                                    <th>ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                            	@foreach($data as $value)
                                <tr class="text-center">
                                	{{-- <td>{{ $count++ }}</td> --}}
                                    <td>{{ $value->fullname }}</td>
                                    <td>{{ $value->phone }}</td>
                                    <td>{{ $value->email }}</td>
                                	<td>
                                        @if(Auth::user()->role != 'viewer')
                                		
                                		<a class="delte text-danger" href="#" data-href="{{ url('Admin/Newsletters/'.$value->id) }}" id="deletecart">
                                			{{-- <i data-feather="trash"></i> --}}
                                            Delete
					                	</a>
                                        @else 
                                        <small class="font-italic">No Action</small>
                                        @endif
                                	</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </div>
@stop
@section('js')
    <script src="//cdn.ckeditor.com/4.13.0/standard/ckeditor.js"></script>
    {{-- <script src="{{ asset('js/filereader.min.js') }}"></script> --}}
	<script type="text/javascript">
        $('.delte').click(function () {
			var id = $(this).data('href');
			$('.btn-ok').attr('action', id);
			$('#deleteModal').modal('show');
		});
	</script>
@stop